<!DOCTYPE html>
<html class="loading bordered-layout" lang="en" data-layout="bordered-layout" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="description" content="Vuexy admin is super flexible, powerful, clean &amp; modern responsive bootstrap 4 admin template with unlimited possibilities.">
    <meta name="keywords" content="admin template, Vuexy admin template, dashboard template, flat admin template, responsive admin template, web app">
    <meta name="author" content="PIXINVENT">
    <title>Product</title>
    <link rel="apple-touch-icon" href="{{ asset('app-assets/images/ico/apple-icon-120.png') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('app-assets/images/ico/favicon.ico') }}">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors.min.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap5.min.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap5.min.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap5.min.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css ') }}">
    <!-- END: Vendor CSS-->
    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap-extended.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/colors.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/components.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/themes/dark-layout.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/themes/bordered-layout.css ') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/themes/semi-dark-layout.css ') }}">
    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/core/menu/menu-types/vertical-menu.css ') }}">
    <!-- END: Page CSS-->
</head>
<!-- END: Head-->
@if($id>0)
@php
$image_required="";
@endphp
@else
@php
$image_required="required";
@endphp
@endif
<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="">
    <!-- BEGIN: Header-->
    @include('admin_layout.header')
    <!-- END: Header-->
    <!-- BEGIN: Main Menu-->
    @include('admin_layout.sidebar')
    <!-- END: Main Menu-->
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">Product</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ url('dashbord') }}">Home</a>
                                    </li>
                                    <!-- <li class="breadcrumb-item"><a href="#">Datatable</a>
                                    </li> -->
                                    <li class="breadcrumb-item active">Product
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
                    <div class="mb-1 breadcrumb-right">
                        <div class="dropdown">
                            <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i data-feather="grid"></i></button>
                            <div class="dropdown-menu dropdown-menu-end"><a class="dropdown-item" href="app-todo.html"><i class="me-1" data-feather="check-square"></i><span class="align-middle">Todo</span></a><a class="dropdown-item" href="app-chat.html"><i class="me-1" data-feather="message-square"></i><span class="align-middle">Chat</span></a><a class="dropdown-item" href="app-email.html"><i class="me-1" data-feather="mail"></i><span class="align-middle">Email</span></a><a class="dropdown-item" href="app-calendar.html"><i class="me-1" data-feather="calendar"></i><span class="align-middle">Calendar</span></a></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <a href="{{url('admin/product')}}">
                            <button class="btn btn-icon btn-primary waves-effect waves-float waves-light" type="button" data-repeater-create="">
                                <i data-feather='arrow-left'></i>
                                <span class="align-middle" style="color: #fff;">Back</span>
                            </button>
                        </a>
                    </div>
                </div>
                <br>
                <!-- message start -->
                @if($message = Session::get('message'))
                <div class="toast-container position-fixed top-0 end-0 p-2" style="z-index: 15">
                    <div class="toast toast-autohide fade show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
                        <div class="toast-header">
                            <img src="../../../app-assets/images/logo/logo.png" class="me-1" alt="Toast Image" height="18" width="25">
                            <strong class="me-auto">Vue Admin</strong>
                            <small class="text-muted">just now</small>
                            <button type="button" class="ms-1 btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                        <div class="toast-body">{{session('message')}}</div>
                    </div>
                </div>
                @endif
                <!-- message end -->
                <!-- Basic Vertical form layout section start -->
                <section id="basic-vertical-layouts">
                    <div class="row">
                        <div class="col-md-12 col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Add New Product</h4>
                                </div>
                                <div class="card-body">
                                    <form class="form form-vertical" method="post" action="{{url('admin/product_add')}}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label">Name</label>
                                                    <input type="text" id="name" class="form-control" name="name" value="{{$name}}" placeholder="Name" />
                                                    @error('name')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label">Slug</label>
                                                    <input type="text" id="category_slug" class="form-control" name="slug" value="{{$slug}}" placeholder="Slug" />
                                                    @error('slug')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label">image</label>
                                                    <input type="file" id="image" class="form-control" name="image" value="{{$image}}" placeholder="image" {{$image_required}} />
                                                    @error('image')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                       
                                            <div class="col-4">
                                                <div class="mb-1">
                                                    <label class="form-label">Category</label>
                                                    <select id="category_id" class="form-control" name="category_id" value="{{$category_id}}">
                                                        <option value="">Select Categories</option>
                                                        @foreach($category as $list)
                                                        @if($category_id==$list->id)
                                                        <option selected value="{{$list->id}}">
                                                            @else
                                                        <option value="{{$list->id}}">
                                                            @endif
                                                            {{$list->category}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    @error('category_id')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                         
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label">short_desc</label>
                                                    <input type="text" id="short_desc" class="form-control" name="short_desc" value="{{$short_desc}}" placeholder="short_desc" />
                                                    @error('short_desc')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-1">
                                                    <label class="form-label">desc</label>
                                                    <input type="text" id="desc" class="form-control" name="desc" value="{{$desc}}" placeholder="desc" />
                                                    @error('desc')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>

                                            <hr>
                                            <div id="product_attr_box" class="row">
                                                <h4 class="card-title">Add Product Attributes</h4>
                                                <div class="col-4">
                                                    <div class="mb-1">
                                                        <label class="form-label">Regular Price</label>
                                                        <input type="text" id="regular" class="form-control" name="regular" value="" placeholder="Regular Price" />
                                                        @error('regular')
                                                        <div class="alert alert-danger" role="alert">
                                                            {{$message}}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-4">
                                                    <div class="mb-1">
                                                        <label class="form-label">Sale Price</label>
                                                        <input type="text" id="sale" class="form-control" name="sale" value="" placeholder="Sale Price" />
                                                        @error('sale')
                                                        <div class="alert alert-danger" role="alert">
                                                            {{$message}}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-4">
                                                <div class="mb-1">
                                                    <label class="form-label">Category</label>
                                                    <select id="category_id" class="form-control" name="category_id" value="{{$category_id}}">
                                                        <option value="">Select Categories</option>
                                                        @foreach($category as $list)
                                                        @if($category_id==$list->id)
                                                        <option selected value="{{$list->id}}">
                                                            @else
                                                        <option value="{{$list->id}}">
                                                            @endif
                                                            {{$list->category}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    @error('category_id')
                                                    <div class="alert alert-danger" role="alert">
                                                        {{$message}}
                                                    </div>
                                                    @enderror
                                                </div>
                                            </div>
                                                <div class="col-4">
                                                    <div class="mb-1">
                                                        <label class="form-label">Image</label>
                                                        <input type="file" id="sale" class="form-control" name="attr_image[]" value="" placeholder="attr_image" />
                                                        @error('sale')
                                                        <div class="alert alert-danger" role="alert">
                                                            {{$message}}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-3">
                                                    <div class="mb-1">
                                                        <label class="form-label"> </label><br>
                                                        <button class="btn btn-icon btn-primary waves-effect waves-float waves-light" type="button" data-repeater-create="" onclick="add_more()">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus me-25">
                                                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                                                <line x1="5" y1="12" x2="19" y2="12"></line>
                                                            </svg>
                                                            <span class="align-middle" style="color: #fff;">Add New</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary me-1">Submit</button>
                                                <button type="reset" class="btn btn-outline-secondary">Reset</button>
                                            </div>
                                            <input type="hidden" name="id" value="{{$id}}">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>
    <!-- BEGIN: Footer-->
    @include('admin_layout.footer')
    <!-- END: Footer-->
    <!-- BEGIN: Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/vendors.min.js ') }}"></script>
    <!-- BEGIN Vendor JS-->
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js ') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js ') }}"></script>
    <!-- END: Page Vendor JS-->
    <!-- BEGIN: Theme JS-->
    <script src="{{ asset('app-assets/js/core/app-menu.js ') }}"></script>
    <script src="{{ asset('app-assets/js/core/app.js ') }}"></script>
    <!-- END: Theme JS-->
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.3/js/dataTables.buttons.min.js"></script>
    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })
    </script>
    <script>
        function add_more() {
            var html = '<hr> <div id="product_attr_box" class="row">';

            html+= ' <div class="col-4"><div class="mb-1"><label class="form-label">Regular Price</label><input type="text" id="regular" class="form-control" name="regular" value="" placeholder="Regular Price" /></div></div>';
            html+= ' <div class="col-4"><div class="mb-1"><label class="form-label">Sale Price</label><input type="text" id="sale" class="form-control" name="sale" value="" placeholder="Sale Price" /></div></div>';
            html+='<div class="col-4"><div class="mb-1"><label class="form-label">Category</label><select id="category_id" class="form-control" name="category_id" value="{{$category_id}}"><option value="">Select Categories</option>@foreach($category as $list)@if($category_id==$list->id)<option selected value="{{$list->id}}">@else<option value="{{$list->id}}">@endif{{$list->category}}</option>@endforeach</select></div></div>';
            html+= ' <div class="col-4"><div class="mb-1"><label class="form-label">Image</label><input type="file" id="sale" class="form-control" name="attr_image[]" value="" placeholder="attr_image" /></div></div>';
            html+= '</div>';

            jQuery('#product_attr_box').append(html)
        }
    </script>
</body>
<!-- END: Body-->

</html>